#include "CProjectil.h"

#include "CApplication.h"

//initialisation du gnrateur de nbres aleatoires
inline void randomize(){
  srand((time_t) time(NULL));                           
}
//gnrateur de nbres alatoires entre 0 et n-1
inline int random(int n){
  return rand()%n;
}

CProjectil::CProjectil(unsigned char mdl,float life,unsigned char dmg,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot)
:CCollideMv(px,py,pz,fx,fy+0.000097,fz,vx,vy,vz,masse,rayon,coefElastic,ffrot)
{
    bobObj.loadObj(CApplication::selfPointer->protoBob.getPrototype(mdl));
    bobObj.setPosition(px,py,pz);
    if(fx==0.0 && fy==0.0 && fz==0.0)bobObj.setOrientation(vx,vy,vz);
    else bobObj.setOrientation(fx,fy,fz);
    this->life=life;
    this->dmg=dmg;
}

CProjectil::~CProjectil()
{
}

void CProjectil::applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg)
{
    dmg=0;
    life=0.0;
    colid_flags=0;
    //cldDisable(IN_LIFE);
}

void CProjectil::applyExplosion(float dmg,float proxi)
{
}

bool CProjectil::frameMove(float elapsedTime)
{
    life-=elapsedTime;
    if(life<=0.0)return true;
    
    return false;
}

void CProjectil::render()
{
    bobObj.draw(pos.x,pos.y,pos.z);
}









void CMissile::applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg)
{
    if(colid_flags)
    {
        dmg=0;
        life=0.0;
        colid_flags=0;
        
        boom();
    }
}

void CMissile::applyExplosion(float dmg,float proxi)
{
    if(colid_flags)
    {
        dmg=0;
        life=0.0;
        colid_flags=0;
        
        boom();
    }
}

void CMissile::boom()
{
    //CApplication::selfPointer->o_son.playSound(EXPLOENM+rand()%EXPLOMSL,pos.z);
    CApplication::selfPointer->o_son.playSound(EXPLOENM+rand()%NBEXPLO,pos.z,0.35);
    if(rand()%2)CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,dmgExp*0.01,600.0,rayon*1.0*3,rayon*1.4*(3+dmgExp*0.06),8,16,17/600.0,128.0/1024.0,128.0/1024.0,0));
    else CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,dmgExp*0.01,600.0,rayon*1.0*3,rayon*1.4*(3+dmgExp*0.06),8,16+17,17/600.0,128.0/1024.0,128.0/1024.0,16));
    srand((time_t) rand());
}

bool CMissile::frameMove(float elapsedTime)
{
    life-=elapsedTime;
    if(life<=0.0)
    {
        if(colid_flags)
        {
            dmg=0;
            colid_flags=0;
            
            boom();
        }
        
        return true;
    }
    
    if(mt.predict(elapsedTime))
    {
        bobObj.getAxeZ(mt.pos);
        mt.pos*=-30.0;
        mt.pos+=pos;
        mD.pos=mt.pos;
        //mD.vel=vel;
        //mD.vel*=-0.1;
        //mt.vel=mD.vel;
    }
    
    mD.frameMove(elapsedTime);
    mt.frameMove(elapsedTime);
    
    return false;
}

CMissile::CMissile(unsigned char mdl,float life,unsigned char dmg,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot)
:CProjectil(mdl,life,1,px,py,pz,fx,fy,fz,vx,vy,vz,masse,rayon,coefElastic,ffrot)
{
    this->dmgExp=dmg;
    
    mt.setIdP(1);mD.setIdP(2);
    mt.setReTm(10.0);mD.setReTm(10.0);
    mt.setLife(70);mD.setLife(90);
    mt.start();
    mD.start();
    
    bobObj.getAxeX(mD.vX);mD.vX*=0.1;
    bobObj.getAxeY(mD.vY);mD.vY*=0.1;
    bobObj.getAxeZ(mD.vel);
    mt.vel=mD.vel;
    mD.vel*=-0.02;
    mt.vel*=-0.005;
    
    force*=0.01;
}

CMissile::~CMissile(){}





bool CMissileEn::frameMove(float elapsedTime)
{
    life-=elapsedTime;
    if(life<=0.0)
    {
        if(colid_flags)
        {
            dmg=0;
            colid_flags=0;
            
            boom();
        }
        
        return true;
    }
    
    if(maj>0.0)maj-=elapsedTime;
    else if(maj<=0.0)
    {
        maj=90.0;
        Vecteur d;
        bobObj.getAxeZ(d);
        if(CApplication::selfPointer->mCld.getDirSearchingHead(this,d,1000.0*1000.0,0.8,1.0))
        {
            bobObj.setOrientationN(d.x,d.y,d.z);
            force=d;
            force*=0.01;
            
            bobObj.getAxeX(mD.vX);mD.vX*=0.1;
            bobObj.getAxeY(mD.vY);mD.vY*=0.1;
            bobObj.getAxeZ(mD.vel);
            mt.vel=mD.vel;
            mD.vel*=-0.02;
            mt.vel*=-0.005;
        }
    }
    
    if(mt.predict(elapsedTime))
    {
        bobObj.getAxeZ(mt.pos);
        mt.pos*=-30.0;
        mt.pos+=pos;
        mD.pos=mt.pos;
        //mD.vel=vel;
        //mD.vel*=-0.1;
        //mt.vel=mD.vel;
    }
    
    mD.frameMove(elapsedTime);
    mt.frameMove(elapsedTime);
    
    return false;
}

CMissileEn::CMissileEn(unsigned char mdl,float life,unsigned char dmg,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot)
:CMissile(mdl,life,dmg,px,py,pz,fx,fy,fz,vx,vy,vz,masse,rayon,coefElastic,ffrot)
{
    maj=10.0;
}

CMissileEn::~CMissileEn()
{
}

/*
CMissileEn::CMissileEn(unsigned char mdl,float life,unsigned char dmg,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot)
:CMissile(mdl,life,dmg,px,py,pz,fx,fy,fz,vx,vy,vz,masse,rayon,coefElastic,ffrot)
{
}

CMissileEn::~CMissileEn()
{
}
*/
